/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*  
*
************************************************************************/

package de.nece.ccrl.advsec.signon;

import de.nece.ccrl.securitycontext.NECSecurityContext;
import eu.gemss.signals.advsecurity.AdvSecSignonSig;
import eu.gemss.signals.Signal;
import java.lang.System;
import de.nece.ccrl.util.Properties;



public class AdvSecSingleSignon {

    private String password = null;
    private String keystore_loc = null;
    private String crl_loc = null;


    public AdvSecSingleSignon(String filename, String directory){	
	try{
	    Properties conf = new Properties(filename);
	    keystore_loc = conf.getProperty("gemss.security.context.javakeystore.keystorepath");
	    try{
		password = conf.getProperty("gemss.security.context.javakeystore.keystorepass");    
	    }catch(Exception f) {password=null;}
	    try{
		crl_loc = conf.getProperty("gemss.security.context.javakeystore.crlfile");
	    }catch(Exception f) {crl_loc=null;}
	}catch(Exception e) {
	    e.printStackTrace();
	    System.out.println("Wrong configuration files path-name");
	}
    }


    public void setPassword(String pwd) {
	password = new String(pwd);
    }

    
    public String getPassword() {
	if (password==null) {
		AdvSecSignonSig signon = new AdvSecSignonSig(this);	
		Signal[] s = eu.gemss.GEMSS.getInstance().generateSignal(signon);
		if (s.length>0) password = ((AdvSecSignonSig) s[0]).getPassword();  
	}

	int test = NECSecurityContext.isKeystore(keystore_loc, password);
	if (test == 1) 
	    {
		this.set_wrong_pwd();
		
	    }
	else if (test == 2)
	    this.set_wrong_keystore();
	return password;
    }

    
    public String askPassword() {
	
	AdvSecSignonSig signon = new AdvSecSignonSig(this);	
	Signal[] s = eu.gemss.GEMSS.getInstance().generateSignal(signon);
	if (s.length>0) password = ((AdvSecSignonSig) s[0]).getPassword();
	int test = NECSecurityContext.isKeystore(keystore_loc,password);
	if (test == 1) 
	    {
		this.set_wrong_pwd();
		
	    }
	else if (test == 2)
	    this.set_wrong_keystore();
	return password;
    }


    public String getKeystoreLoc() {
	return keystore_loc;
    }

    public String getCrlLoc() {
	return crl_loc;
    }

    private void set_wrong_pwd(){
	AdvSecSignonSig signon = new AdvSecSignonSig(this);	
	signon.set_wrong_pwd();
	Signal[] s = eu.gemss.GEMSS.getInstance().generateSignal(signon);
	System.exit(0);
    }

    private void set_wrong_keystore(){
	AdvSecSignonSig signon = new AdvSecSignonSig(this);	
	signon.set_wrong_keystore();
	Signal[] s = eu.gemss.GEMSS.getInstance().generateSignal(signon);
	System.exit(0);
    }

}
