/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext;

import eu.gemss.components.security.GEMSSSecurityContext;
import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.TokenDescriptor;
import de.nece.ccrl.securitycontext.tokenprovider.*;
import eu.gemss.components.security.token.store.StoreProviderException;
import de.nece.ccrl.advsec.signon.AdvSecSingleSignon;



public class NECSecurityContext implements GEMSSSecurityContext{

    private String keystore_loc = null;
    private String password = null;
    private String crl_loc = null;

    public NECSecurityContext(String directory, String filename) throws eu.gemss.GridException{	
	AdvSecSingleSignon s = new AdvSecSingleSignon(filename, directory);
	password = s.getPassword();
	keystore_loc = s.getKeystoreLoc();
	crl_loc = s.getCrlLoc();
    }


    public void addSecurityTokenToContext(SecurityToken token) throws eu.gemss.GridException{
	NECTokenStoreProvider prov = new NECTokenStoreProvider();
	prov.setKeystore(keystore_loc,password);
	prov.addSecurityToken(token);
    }

    public SecurityToken generateSecurityToken(TokenDescriptor desc) throws eu.gemss.GridException{
	NECSecurityTokenProvider prov = new NECSecurityTokenProvider();
	prov.setKeystore(keystore_loc,password);
	return prov.generateSecurityToken(desc);
    }

    public SecurityToken getSecurityToken(TokenDescriptor desc) throws eu.gemss.GridException{
	NECTokenStoreProvider prov = new NECTokenStoreProvider();
	prov.setKeystore(keystore_loc,password);
	return prov.getSecurityToken(desc);
    }

    public boolean isTrusted(SecurityToken token) throws eu.gemss.GridException{
	NECTrustProvider prov = new NECTrustProvider();
	prov.setKeystore(keystore_loc,password,crl_loc);
	boolean ist=false;
	try{
	    ist = prov.isTrusted(token);
	}catch(Exception e) {
	    e.printStackTrace();
	    return false;
	}
	return ist;
    }

    public void removeSecurityTokenFromContext(SecurityToken token) throws eu.gemss.GridException{
	NECTokenStoreProvider prov = new NECTokenStoreProvider();
	prov.setKeystore(keystore_loc,password);
	prov.removeSecurityToken(token);
    }

    
    public String getInitiator() throws eu.gemss.GridException {
	NECTokenStoreProvider prov = new NECTokenStoreProvider();
	prov.setKeystore(keystore_loc,password);
	String initiator = null;
	try {
	    initiator = prov.getInitiator();
	} catch (StoreProviderException e) {throw new eu.gemss.GridException(e.getMessage(),null);}
	return initiator;
    }

    static public int isKeystore(String keystore_loc, String password) {
	return NECTokenStoreProvider.isKeystore(keystore_loc,password);
 
    }

}
