/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.contexttoken;

import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.SecurityToken;


public class SecurityContextTokenDescriptor implements TokenDescriptor {
    
    static final String NSL_PROT = "NSL";

    String protocol;
    String service;
    String tokenservice;
    SecurityToken[] supporttokens;
    static final String description = "Security Context Token";
   
 
    public SecurityContextTokenDescriptor(String protocol) {
	this.protocol = protocol;
	this.service = null;
	this.tokenservice = null;
	this.supporttokens = null;
	
    }


    public SecurityContextTokenDescriptor(String protocol, String service, String tokenservice) {
	this.protocol = protocol;
	this.service = service;
	this.tokenservice = tokenservice;
	this.supporttokens = null;
	
    }

    public void setService(String service) {
	this.service = service;
    }

 
    public void setTokenService(String tokenservice) {
	this.tokenservice = tokenservice;
    }

    public void setSupportTokens(SecurityToken[] supporttokens){
	this.supporttokens = supporttokens;
    }

    public String getDescription() {
	return description;
    }
	
    public String getProtocol() {
	return protocol;
    }

    public String getService() {
	return service;
    }

    public String getTokenService() {
	return tokenservice;
    }

    public SecurityToken[] getSupportTokens(){
	return supporttokens;
    }

    public boolean isEqual(TokenDescriptor d) {
	if (!(d instanceof SecurityContextTokenDescriptor)) return false;
	else 
	    if ((this.service == null) 
		|| (((SecurityContextTokenDescriptor)d).getService() == null))
		return (protocol.equals(((SecurityContextTokenDescriptor)d).getProtocol()) 
			&& description.equals(((SecurityContextTokenDescriptor) d).getDescription()));
	    else
		return (protocol.equals(((SecurityContextTokenDescriptor)d).getProtocol()) 
			&& description.equals(((SecurityContextTokenDescriptor) d).getDescription())
			&& service.equals(((SecurityContextTokenDescriptor) d).getService()));
    }

}
