/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.contexttoken;

import eu.gemss.components.security.token.types.contexttoken.SecurityContextToken;
import eu.gemss.components.security.token.*;
import de.nece.ccrl.securitycontext.token.types.key.asymmetric.PrivateKeyTokenImpl;
import de.nece.ccrl.securitycontext.token.types.key.asymmetric.PublicKeyTokenImpl;
import de.nece.ccrl.securitycontext.token.types.pki.X509CertificateTokenImpl;
import eu.gemss.components.security.token.types.key.symmetric.SecretKeyToken;
import java.util.Date;
import java.security.Key;
import java.io.*;



public class SecurityContextTokenImpl implements SecurityContextToken, Key{
    
    SecurityToken token;
    String protocol;
    String service;
    String tokenservice;
    Date expirationdate;
    

    public SecurityContextTokenImpl(SecurityToken token) {
	this.protocol = "unknown";
	this.token = token;
	service = null;
	tokenservice = null;
	expirationdate = null;

    }
    
    public SecurityContextTokenImpl(SecurityToken token, String protocol) {
	this.protocol = protocol;
	this.token = token;
	service = null;
	tokenservice = null;
	expirationdate = null;
    }

    public SecurityContextTokenImpl(SecurityToken token, String protocol, String service, String tokenservice) {
	this.protocol = protocol;
	this.token = token;
	this.service = service;
	this.tokenservice = tokenservice;
	expirationdate = null;
    }

    public SecurityContextTokenImpl(SecurityToken token, String protocol, String service, String tokenservice, Date exp) {
	this.protocol = protocol;
	this.token = token;
	this.service = service;
	this.tokenservice = tokenservice;
	this.expirationdate = exp;
    }

    public SecurityContextTokenImpl(SecurityToken token, String protocol, String service, String tokenservice, int timeframe) {
	this.protocol = protocol;
	this.token = token;
	this.service = service;
	this.tokenservice = tokenservice;
	this.expirationdate = new Date();
	expirationdate.setTime(expirationdate.getTime()+timeframe);
	
    }

    public void setService(String service){
	this.service = service;
    }

   

    public void setTokenService(String tokenservice){
	this.tokenservice = tokenservice;
    }
    
    public void setAlgorithm(String protocol) {
	this.protocol = protocol;
    }

    public void setExpirationDate(int timeframe){
	expirationdate = new Date();
	expirationdate.setTime(expirationdate.getTime()+timeframe);
    }

    public void setExpirationDate(Date date){
	expirationdate = date;
    }

    public Date getExpirationDate(){
	return expirationdate;
    }

    public TokenDescriptor getTokenDescriptor() {
	return new SecurityContextTokenDescriptor(protocol,service,tokenservice);
    }

    public SecurityToken getIncludedToken() {
	return token;
    }

    public boolean isExpired() {
	Date now = new Date();
	if (expirationdate==null) return false;
	else return now.after(expirationdate);	
    }

    public String getAlgorithm() {
	return this.protocol;
    }

    public byte[] getEncoded() {
	
	byte[] b = null;
 
	try{
	    ByteArrayOutputStream bos = new ByteArrayOutputStream();
	    ObjectOutputStream oos = new ObjectOutputStream(bos);
	    oos.writeObject(this);
	    b = bos.toByteArray();
	}catch(Exception e) {
	    e.printStackTrace();
	    System.exit(0);
	}

	return b;
    }

    public String getFormat() {
	// it is essential that the format is "RAW" for the bouncy castle keystore to work
	return "RAW";
    }

    public boolean equals(SecurityToken t) {

	if (!(t instanceof SecurityContextToken)) return false;

	SecurityContextTokenDescriptor d = null;
	try{
	    d = (SecurityContextTokenDescriptor) ((SecurityContextToken)t).getTokenDescriptor();
	} catch (Exception e) {}


	if (this.token instanceof SecretKeyToken) 
	    return 
		(((SecretKeyToken) this.token).equals(((SecurityContextToken)t).getIncludedToken()) &&
		 (this.getTokenDescriptor()).isEqual(d));

	if (this.token instanceof SecurityContextToken)
	    return 
		(((SecurityContextToken) this.token).equals(((SecurityContextToken)t).getIncludedToken()) &&
		 (this.getTokenDescriptor()).isEqual(d));

	if (this.token instanceof X509CertificateTokenImpl) 
	    return 
		(((X509CertificateTokenImpl) this.token).equals(((SecurityContextToken)t).getIncludedToken()) &&
		 (this.getTokenDescriptor()).isEqual(d));

	if (this.token instanceof PublicKeyTokenImpl) 
	    return 
		(((PublicKeyTokenImpl) this.token).equals(((SecurityContextToken)t).getIncludedToken()) &&
		 (this.getTokenDescriptor()).isEqual(d));

	if (this.token instanceof PrivateKeyTokenImpl) 
	    return 
		(((PrivateKeyTokenImpl) this.token).equals(((SecurityContextToken)t).getIncludedToken()) &&
		 (this.getTokenDescriptor()).isEqual(d));

	return false;
    }

}
