/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.key;

import eu.gemss.components.security.token.TokenDescriptor;
import java.util.List;


public class KeyDescriptor implements TokenDescriptor{

    public static final String PUB_KEY = "Public Key";
    public static final String PRIV_KEY = "Private Key";
    public static final String SYM_KEY = "Symmetric Key";

    public static final String DSA = "DSA";
    public static final String RSA = "RSA";
    public static final String DES = "DES";
 
    String algorithm;
    String description;
    List owners;

    public KeyDescriptor(String description, String alg) {
	algorithm = alg;
	this.description = description;
	owners = null;
    }

    public KeyDescriptor(String description, String alg, List own) {
	algorithm = alg;
	this.description = description;
	owners = own;
    } 

    public void setOwners(List own){
	owners = own;
    }

    public String getDescription() {
	return description;
    }
 
    public String getAlgorithm() {
	return algorithm;
    }
    
    public List getOwners(){
	return owners;
    }

    public boolean isEqual(TokenDescriptor d) {
	if (!(d instanceof KeyDescriptor)) return false;
	else 
	    if ((this.owners == null) || (((KeyDescriptor)d).getOwners() == null))
		return (algorithm.equals(((KeyDescriptor)d).getAlgorithm()) 
			&& description.equals(((KeyDescriptor) d).getDescription()));
	    else
		return (algorithm.equals(((KeyDescriptor)d).getAlgorithm()) 
			&& description.equals(((KeyDescriptor) d).getDescription())
			&& owners.equals(((KeyDescriptor) d).getOwners()));
    }
}
