/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.key.asymmetric;

import java.security.PublicKey;

import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.types.key.asymmetric.PublicKeyToken;
import de.nece.ccrl.securitycontext.token.types.key.KeyDescriptor;
import eu.gemss.components.security.token.TokenDescriptor;
import java.util.ArrayList;

public class PublicKeyTokenImpl implements PublicKeyToken, java.io.Serializable{

    PublicKey key;
    ArrayList owners;

    public PublicKeyTokenImpl(PublicKey key) {
	this.key = key;
	owners = null;
    }

    public PublicKeyTokenImpl(PublicKey key, String owner){
	this.key = key;
	owners = new ArrayList();
	owners.add(owner);
    }

    public String getAlgorithm(){
	return key.getAlgorithm();
    }

    public String getEncodingFormat(){
	return key.getFormat();
    }

    public byte[] getEncoded(){
	return key.getEncoded();
    }

    public PublicKey getKey(){
	return key;
    } 

    public TokenDescriptor getTokenDescriptor(){	
	return new KeyDescriptor(KeyDescriptor.PUB_KEY, key.getAlgorithm(), owners);
    }
    
    public boolean equals(SecurityToken t){
	
	if (!(t instanceof PublicKeyToken)) return false;

	PublicKey k = null;
	try{
	    k = ((PublicKeyToken)t).getKey();
	}catch (Exception e) {}
	return key.equals(k);
    }    

    public int hashCode(){
	return key.hashCode();
    }

}
