/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.key.symmetric;

import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.TokenDescriptor;
import de.nece.ccrl.securitycontext.token.types.key.KeyDescriptor;
import eu.gemss.components.security.token.types.key.symmetric.SecretKeyToken;
import javax.crypto.SecretKey;
import java.security.Key;
import java.util.List;
import java.io.*;

public class SecretKeyTokenImpl implements SecretKeyToken, Key {

    SecretKey key;
    List owners;


    public SecretKeyTokenImpl(SecretKey k){
	key = k;
	owners = null;;
    }

    public SecretKeyTokenImpl(SecretKey k, List owners){
	key = k;
	this.owners = owners;
    }

    public void setOwners(List owners){
	this.owners = owners;
    }

    public List getOwners(){
	return owners;
    }


    // for now only DES Support

    public TokenDescriptor getTokenDescriptor(){	
	String alg = key.getAlgorithm();
	if (alg.equals("DESKeySpec")) alg = KeyDescriptor.DES; 
	return new KeyDescriptor(KeyDescriptor.SYM_KEY, alg,owners);
    }

    public SecretKey getKey() {
	return key;
    }

    public String getEncodingFormat() {
	return "RAW";
    }

    public String getFormat() {
	return "RAW";
    }

    public byte[] getEncoded() {
	
	byte[] b = null;

	try{
	    ByteArrayOutputStream bos = new ByteArrayOutputStream();
	    ObjectOutputStream oos = new ObjectOutputStream(bos);
	    oos.writeObject(this);
	    b = bos.toByteArray();
	}catch(Exception e) {
	    e.printStackTrace();
	    System.exit(0);
	}
	
	return b;
    }

    public String getAlgorithm(){
	String alg = key.getAlgorithm();
	if (alg.equals("DESKeySpec")) alg = KeyDescriptor.DES; 
	return alg;
    }

    public boolean equals(SecurityToken ks){
	if (!(ks instanceof SecretKeyToken)) return false;
	TokenDescriptor d1 = null, d2 = null;
	try{
	    d1 = ks.getTokenDescriptor();
	    d2 = ((SecretKeyToken)ks).getTokenDescriptor();
	}catch(Exception e) {}
	return d1.isEqual(d2);
    }    

    public int hashCode(){
	return key.hashCode();
    }

}
