/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.pki;

import eu.gemss.components.security.token.TokenDescriptor;


public class CertificateDescriptor implements TokenDescriptor{

    public static final String X509 = "X.509";

    String description;
    String owner;
    String altnames = "#UNDEFINED#";

    public CertificateDescriptor(String type, String owner){
	description = type;
	this.owner = owner;
    }

    public CertificateDescriptor(String type, String owner, String alt){
	description = type;
	this.owner = owner;
	if ((alt!=null)&&(alt.length()>0)) {
	    String[] ar = alt.split("//");
	    if (ar.length>1) altnames = ar[1];
	}
    }

    public CertificateDescriptor(String type){
	description = type;
	this.owner =  null;
    }

    public void setOwner(String owner) {
	this.owner = owner;
    }

    public void setAltNames(String alt) {
	if ((alt!=null)&&(alt.length()>0)) {
	    String[] ar = alt.split("//");
	    if (ar.length>1) altnames = ar[1];
	}
    }

    public String getDescription() {
	return description;
    }

    public String getOwner() {
	return owner;
    }

    public String getAltNames() {
	return altnames;
    }
 
    public boolean isEqual(TokenDescriptor d) {
	if (d instanceof CertificateDescriptor) {
	    String desc = ((CertificateDescriptor) d).getDescription();
	    String ow = ((CertificateDescriptor) d).getOwner();
	    String alt = ((CertificateDescriptor) d).getAltNames();
	

	    boolean b = (description.equals(desc)
		    && (owner.matches(".*"+ow+".*") ||
			owner.matches(alt+"*") ||
			ow.matches(".*"+owner+".*") ||
		        ow.matches(altnames+".*"))
		    );

	

	    return b;
	}
	else return false;
    }
}

