/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.securitycontext.token.types.pki;

import eu.gemss.components.security.token.types.key.asymmetric.PublicKeyToken;
import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.SecurityTokenException;
import eu.gemss.components.security.token.types.pki.X509CertificateToken;
import eu.gemss.components.security.token.TokenDescriptor;
import de.nece.ccrl.securitycontext.token.types.pki.CertificateDescriptor;
import de.nece.ccrl.securitycontext.token.types.key.asymmetric.PublicKeyTokenImpl;
import java.security.cert.X509Certificate;



public class X509CertificateTokenImpl implements X509CertificateToken, java.io.Serializable {

    X509Certificate cert;

    public X509CertificateTokenImpl(X509Certificate cert){
	this.cert = cert;
    }

    public byte[] getEncoded() throws SecurityTokenException{
	try{
	    return cert.getEncoded();
	} catch (Exception e) {throw new SecurityTokenException("Internal encoding failure");}
    }

    public PublicKeyToken getPublicKeyToken() throws SecurityTokenException{
	return new PublicKeyTokenImpl(cert.getPublicKey(),(cert.getSubjectX500Principal()).toString());
    }

    public String getIssuerDN() throws SecurityTokenException{
	return (cert.getIssuerX500Principal()).toString();
    }

    public String getSubjectDN() throws SecurityTokenException{
	return (cert.getSubjectX500Principal()).toString();
    }

    public X509Certificate getX509Certificate() throws SecurityTokenException{
	return cert;
    }

    public TokenDescriptor getTokenDescriptor() throws SecurityTokenException{
	return new CertificateDescriptor(CertificateDescriptor.X509, (cert.getSubjectX500Principal()).toString());
    }


    public boolean equals(SecurityToken t) {

	if (!(t instanceof X509CertificateToken)) return false;

	CertificateDescriptor d = null, tempdesc = null;
	X509Certificate tempcert = null;
	try{
	    d = (CertificateDescriptor) ((X509CertificateToken)t).getTokenDescriptor();
	    tempcert = ((X509CertificateToken)t).getX509Certificate();
	    tempdesc = (CertificateDescriptor) this.getTokenDescriptor();
	} catch (Exception e) {}

	return 
	    cert.equals(tempcert) &&
	     (tempdesc).isEqual(d);
    }
   
}
