/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.tokenmanager.drivers.apachetestdriver;

import org.xmlsoap.schemas.ws._2002._12.secext.*;
import de.nece.ccrl.schemas.sessid.holders.SessionIdTypeHolder;
import de.nece.ccrl.tokenmanager.*;
import de.nece.ccrl.tokenmanager.policies.PolicyProcessorProvider;
import de.nece.ccrl.tokenservice.*;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import java.lang.System;

public class ApacheDriver implements TokenManagerDriver {




    String endpoint = null;

    public ApacheDriver(String endpoint) {
	
	this.endpoint = endpoint;


    }


    public RequestSecurityTokenResponseType invoke(SessionIdTypeHolder sidh, RequestSecurityTokenType request, TokenManagerPolicy[] outp, TokenManagerPolicy[] inp) 
	throws TokenManagerException {

	if (endpoint == null) throw new TokenManagerException("Apache Driver needs endpoint information");
	
	RequestSecurityTokenResponseType response;
	TokenService service = new TokenServiceLocator(endpoint);
	SecurityTokenService port = null;

	try{
	    port = service.getNSL();
	} catch (javax.xml.rpc.ServiceException e) { throw new TokenManagerException("" + e.getLinkedCause()); }

	

	//set HTTP socket timeout in milliseconds

	org.apache.axis.client.Stub s = (org.apache.axis.client.Stub) port;

	s.setTimeout(100000);

	Handler h = null;
	int i;
	PolicyProcessorProvider provider = new PolicyProcessorProvider();


	if (outp!=null) {
	 
	    // prepare and set request Handlers
	    
	    SimpleChain reqHandler = new SimpleChain();
	    for (i=0; i < outp.length; i++) {
		h = (Handler) provider.getPolicyProcessor(outp[i]);
		reqHandler.addHandler(h);
	    }
	    
	    s._setProperty("requestHandler", h);
	}

	if (inp!=null) {

	    // prepare and set response Handlers
	    
	    SimpleChain respHandler = new SimpleChain();
	    for (i=0; i < outp.length; i++) {
		h = (Handler) provider.getPolicyProcessor(inp[i]);
		respHandler.addHandler(h);
	    }
	    
	    s._setProperty("responseHandler", respHandler);
	}


	System.out.println("Security Token Service invocation started ...");
	System.out.println("Contacting: " + endpoint);

	try {
	    response = port.requestSecurityToken(sidh,request);
	} catch (java.rmi.RemoteException e) { 
	    e.printStackTrace();
	    throw new TokenManagerException("Server-side or handler problem -- " + e.getMessage()); }

	System.out.println("Security Token Service invocation completed.");
	return response;

    }






}
