/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/

package de.nece.ccrl.tokenmanager.drivers.apachetestdriver;

import org.apache.axis.components.net.*;
import com.sun.net.ssl.SSLContext;
import java.security.KeyStore;
import java.util.Hashtable;
import java.io.FileInputStream;
import java.io.InputStream;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.TrustManager;

import de.nece.ccrl.advsec.signon.AdvSecSingleSignon;


public class NECJSSESocketFactory extends SunJSSESocketFactory {
 

	public NECJSSESocketFactory(Hashtable attributes) {
        super(attributes);
    }

	
    protected SSLContext getContext() throws Exception {
     
    	String pt = System.getProperty("gemss.home");
    	
    	if (pt==null) System.out.println("No System Property gemss.home set");
    	
    	AdvSecSingleSignon s = new AdvSecSingleSignon(pt+"/config/gemss.security.context.properties",pt);
    	String ksPassword = s.getPassword();
    	String ksFile = s.getKeystoreLoc();
	
    	KeyStore keystore = KeyStore.getInstance("JKS");
    	InputStream istream = new FileInputStream(ksFile);
    	keystore.load(istream, ksPassword.toCharArray());
       
    	KeyManagerFactory kmfact = KeyManagerFactory.getInstance("SunX509");

        kmfact.init(keystore, ksPassword.toCharArray());

        TrustManager[] tm = null;

        TrustManagerFactory tmfact = TrustManagerFactory.getInstance("SunX509");

        tmfact.init(keystore);
        tm = tmfact.getTrustManagers();
  
        SSLContext context = com.sun.net.ssl.SSLContext.getInstance("SSL");  
        
        context.init(kmfact.getKeyManagers(), tm, new java.security.SecureRandom());
        
        return context;
    }

   
}
