/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.tokenmanager.drivers.apachetestdriver;


import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.types.key.asymmetric.PrivateKeyToken;
import de.nece.ccrl.securitycontext.NECSecurityContext;
import de.nece.ccrl.tokenmanager.policies.PrivDecrPolicy;
import de.nece.ccrl.securitycontext.token.types.key.KeyDescriptor;
import de.nece.ccrl.tokenmanager.*;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.Message;
import de.nece.ccrl.transport.soapProcessors.*;

public class  PrivDecrProcessor extends BasicHandler implements PolicyProcessor {    

    PrivDecrPolicy policy = null;

    public PrivDecrProcessor(PrivDecrPolicy p){
	policy = p;
    }

    public void setPolicy(PrivDecrPolicy p){
	policy = p;
    }

    public void invoke(MessageContext cxt) throws AxisFault {

	System.out.println("Private key decryption started ...");

	// instantiate a security context 
	String pt = System.getProperty("gemss.home");
	if (pt==null) System.out.println("No System Property gemss.home set");
	NECSecurityContext seccxt = null;
	try{
	    seccxt = new NECSecurityContext(pt, pt+"/config/gemss.security.context.properties");
	} catch (Exception e) {throw new AxisFault("Security Context configuration error");}


	// construct token descriptor from the policy

	if (policy==null) throw new AxisFault("Policy must be set on Processor");

	String type = policy.getKeyType();
	String alg = policy.getAlgorithm();
	KeyDescriptor tokendesc = new KeyDescriptor(type,alg);


	// retrive token from keystore

	System.out.println("Get my private key.");
	
	SecurityToken token = null;
	try{
	    token = seccxt.getSecurityToken(tokendesc);
	} catch (Exception e) {throw new AxisFault("Unexpected Security Context error");}

	if ((token==null) || (!(token instanceof PrivateKeyToken))) 
	    throw new AxisFault("Private-key certificate not available");
	
	// DO Decryption & change the message through the message context 

	SimpleWSEncryption enc = new SimpleWSEncryption();
	Message msg = (Message) cxt.getMessage();
	String owner = null;

	try{
	    owner = (String) ((KeyDescriptor) token.getTokenDescriptor()).getOwners().get(0);
	    msg = (Message) enc.decrypt(msg, cxt.getTypeMapping(), ((PrivateKeyToken) token).getKey());
	    cxt.setMessage(msg);
	}catch(Exception e) {throw new AxisFault("Unexptected fault");}

	System.out.println("Private key decryption completed.");

	
    }

 
 
}
