/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.tokenmanager.drivers.apachetestdriver;


import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.types.pki.CertificateToken;
import eu.gemss.components.security.token.types.key.asymmetric.PublicKeyToken;
import de.nece.ccrl.securitycontext.NECSecurityContext;
import de.nece.ccrl.tokenmanager.policies.PubEncrPolicy;
import de.nece.ccrl.securitycontext.token.types.pki.CertificateDescriptor;

import de.nece.ccrl.tokenmanager.*;
import org.apache.axis.AxisFault;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.MessageContext;
import org.apache.axis.Message;
import de.nece.ccrl.transport.soapProcessors.*;

public class  PubEncrProcessor extends BasicHandler implements PolicyProcessor {    

    PubEncrPolicy policy = null;

    public PubEncrProcessor(PubEncrPolicy p){
	policy = p;
    }

    public void setPolicy(PubEncrPolicy p){
	policy = p;
    }

    public void invoke(MessageContext cxt) throws AxisFault {

	System.out.println("Public key encryption started ...");

       	// instantiate a security context 


	NECSecurityContext seccxt = null;

	String pt = System.getProperty("gemss.home");
	if (pt==null) System.out.println("No System Property gemss.home set");
	try{
	    seccxt = new NECSecurityContext(pt,pt+"/config/gemss.security.context.properties");
	} catch (Exception e) {throw new AxisFault("Security Context configuration error");}


	
	// construct token descriptor for the certificate

        String owner = policy.getOwner();
	String type = policy.getCertificateType();
	CertificateDescriptor tokendesc = new CertificateDescriptor(type,owner);


	// retrive certificate from keystore

	System.out.println("Get public key of: " + owner);
		
	SecurityToken token = null;
	try{
	    token = seccxt.getSecurityToken(tokendesc);
	} catch (Exception e) {throw new AxisFault("Unexpected Security Context error");}
	
	if ((token==null) || (!(token instanceof CertificateToken))) 
	    throw new AxisFault("Public-key certificate not available");
	

	// check if certificate is trusted 

	
	try{
	        if (!(seccxt.isTrusted(token))) throw new AxisFault("Untrusted Certificate"); 
	}catch(Exception e) {e.printStackTrace();}

	// extract public key

	PublicKeyToken pubk = null;
	try{
	    pubk = ((CertificateToken) token).getPublicKeyToken();
	} catch (Exception e) {throw new AxisFault("Public key can not be extracted form certificate");}
	

	// DO ENCRYPTION & "return" message
	
	SimpleWSEncryption enc = new SimpleWSEncryption();
	Message msg = (Message) cxt.getMessage();
	
	try{
	    enc.encrypt(msg, cxt.getTypeMapping(), pubk.getKey(), owner, "RSA");
	}catch(Exception a) {throw new AxisFault("Unexpected fault");}	

	System.out.println("Public-key encryption completed.");

	
    }
 
}
