/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.tokenmanager.policies;

import de.nece.ccrl.tokenmanager.*;
import de.nece.ccrl.tokenmanager.drivers.apachetestdriver.*;

public class  PolicyProcessorProvider{    

    public PolicyProcessor getPolicyProcessor(TokenManagerPolicy p) throws TokenManagerException {
	if (p instanceof PubEncrPolicy) return new PubEncrProcessor((PubEncrPolicy) p);
	else if (p instanceof PrivDecrPolicy) return new PrivDecrProcessor((PrivDecrPolicy) p);
	else throw new TokenManagerException("Unsupported policy type");
    }    
 
}
