/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.tokenservice;

import org.xmlsoap.schemas.ws._2002._12.secext.*;
import de.nece.ccrl.sessionmanager.*;
import de.nece.ccrl.schemas.sessid.holders.*;
import java.util.*;
import org.apache.axis.MessageContext;
import java.util.logging.*;
    
    

public class X509ExchServiceSoapBindingImpl implements SecurityTokenService{


    private static Logger logger = Logger.getLogger("logging.advancedSecurity");

    public X509ExchServiceSoapBindingImpl() {
    }


    public RequestSecurityTokenResponseType requestSecurityToken(SessionIdTypeHolder sessionid, RequestSecurityTokenType req) throws java.rmi.RemoteException, ErrorMsg {


	MessageContext cxt = MessageContext.getCurrentContext();
	
	logger.info("Responding Security Token Service: " + cxt.getProperty(MessageContext.TRANS_URL));

	RequestSecurityTokenResponseType resp = null;
       
	SessionManager sm = new SessionManagerImpl();
	String sessionclass = "de.nece.ccrl.tokenservice.sessions.X509ExchangeSession";
	HashSet portnames = new HashSet();
	
	portnames.add("in");
	portnames.add("out");


	
	    
	SessionContext sessioncxt = null; 
	
	try{

	    sessioncxt = sm.accessSession(sessionclass,sessionid,portnames);

	// it asks the session to respond according to a request. The setRequest method is
	//   synchronized and it blocks until a response is available 

	    SessionPort requests = sessioncxt.getSessionPort("in");
	    SessionPort responses = sessioncxt.getSessionPort("out");

	    requests.setValue(req);
	  
	    resp = (RequestSecurityTokenResponseType) responses.getValue();
  
      	   
	} catch (SessionContextException e) { 
	    try{
		sessioncxt.terminateContext(0);
	    } catch (SessionContextException a) {logger.info("Unexpected exception when trying to terminate session context");}
	    logger.info("X509Exchange session failed -- " + e.getExceptionMsg()); 
	} 
	
	return resp;

	
    }

}
