/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.tokenservice.registry;


import java.util.List;
import java.util.Iterator;
import java.io.File;
import org.jdom.input.SAXBuilder;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Element;
import org.jdom.Namespace;

public class RegistryImpl implements Registry {

    // assuming that $CATALINA_HOME is the directory of installation for tomcat and that
    // the starting script of tomcat sets this as the system property catalina.home.
    static final String FILENAME = System.getProperty("catalina.home") + "/advsec_conf/registry.xml";
    Document registryDoc;

    public RegistryImpl() {
	try {
	    SAXBuilder builder = new SAXBuilder();
	    registryDoc = 
		builder.build(new File(FILENAME));
	} catch(JDOMException e) {
	    e.printStackTrace();
	} catch(NullPointerException e) {
	    e.printStackTrace();
	}
	
    }

    public KeystoreAccessor getAccessor(String name){
	
	Namespace ns = Namespace.getNamespace("registry.tokenservice.ccrl.nece.de");
	Element root = registryDoc.getRootElement();
	List storelist = root.getChildren("store", ns);
	Iterator i = storelist.iterator();
	Element el;
	while(i.hasNext()) {
	    el = (Element) i.next();
	    if ((el.getChildText("name", ns)).equals(name))
		return new KeystoreAccessorImpl(el.getChildText("configfile",ns));
	}

	return null;
    }
    
}
