/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.transport.processor;

import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.providers.MessageProcessorProviderSpi;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.MessageProcessor;
import eu.gemss.components.transport.servicedescription.policytypes.PolicyTypeDescriptor;
import eu.gemss.signals.SignalHandler;
import uk.ac.soton.itinnovation.gemss.transportmessaging.configuration.MessagingProviderConfiguration;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.MessageProcessingException;
import de.nece.ccrl.securitycontext.policies.*;
import java.util.ArrayList;


public class  NECProcessorProvider implements MessageProcessorProviderSpi {    

    private static final NSLPolicyDescriptor nsl_desc = new NSLPolicyDescriptor();
    private static final X509ExchPolicyDescriptor x509_desc = new X509ExchPolicyDescriptor();
    private static final SymEncrPolicyServDescriptor symencserv_desc = new SymEncrPolicyServDescriptor();
    private static final SymDecrPolicyServDescriptor symdecserv_desc = new SymDecrPolicyServDescriptor();
    private static final SymEncrPolicyDescriptor symenc_desc = new SymEncrPolicyDescriptor();
    private static final SymDecrPolicyDescriptor symdec_desc = new SymDecrPolicyDescriptor();


  

    public MessageProcessor getMessageProcessor(PolicyTypeDescriptor d) throws MessageProcessingException {	
	
	if (d instanceof NSLPolicyDescriptor) return new NSLProcessor();
	else if (d instanceof X509ExchPolicyDescriptor) return new X509ExchProcessor();
	else if (d instanceof SymEncrPolicyServDescriptor) return new SymEncrProcessorServ();
	else if (d instanceof SymDecrPolicyServDescriptor) return new SymDecrProcessorServ();
	else if (d instanceof SymEncrPolicyDescriptor) return new SymEncrProcessor();
	else if (d instanceof SymDecrPolicyDescriptor) return new SymDecrProcessor();
	else throw new MessageProcessingException("Unsupported policy type");
    }    

    public PolicyTypeDescriptor[] getSupportedPolicyTypeList() {
	ArrayList list = new ArrayList();
	list.add(nsl_desc);
	list.add(x509_desc);
	list.add(symenc_desc);
	list.add(symdec_desc);
        list.add(symencserv_desc);
	list.add(symdecserv_desc);
	return (PolicyTypeDescriptor[]) list.toArray(new PolicyTypeDescriptor[6]);
    }
   
    public void setMessagingProviderConfiguration(MessagingProviderConfiguration conf) {
	// Not needed? 
    }

    public void setSignalHandler(SignalHandler handler){
	// Not needed?
    }
 
}
