/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/


package de.nece.ccrl.transport.soapProcessors;


import java.io.*;
import javax.crypto.Cipher;
import de.nece.ccrl.util.OutputInputStream;

public class FillCryptotext extends Thread {    
    
    InputStream istream;
    OutputInputStream pOut;
    Cipher c;

    public FillCryptotext(InputStream istream, OutputInputStream pOut, Cipher c){
	this.istream = istream;
	this.pOut = pOut;
	this.c = c;
    }



    public void run() {
	
	try{
	
	    byte[] buf = new byte[1024];
	    byte[] cbuf = null;
	    int numRead = 0;
	    int size = 0;
	    int i;
	

	    while ((numRead = istream.read(buf)) >= 0) {	
		
		size = c.getOutputSize(numRead);	
		cbuf = new byte[size];	
		i = c.update(buf,0,numRead,cbuf);
		if (i > 0) pOut.write(cbuf,i);	
	    } 

	   
	    
	    size = c.getOutputSize(0);
	    cbuf = new byte[size];
	    i = c.doFinal(cbuf,0);
	    pOut.write(cbuf,i);	
	    pOut.close();


	}catch(Exception e) {e.printStackTrace();}
    }
}









