/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.docmonitor;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;


import de.nece.ccrle.docmonitor.DocMonitor;

import eu.gemss.components.providers.Provider;
import eu.gemss.components.ServiceRequest;


/**
 * A factory class for providing <code>DocMonitor</code> implementations.
 *
 * @author Greg Kohring
 */
public class DocMonitorProvider implements Provider {
                                                                                
    private static boolean local = true;
    private static String name = "de.nece.ccrle.DocMonitorProvider";
    private static String version = null;
    private static String component = "de.nece.ccrle.docmonitor.DocMonitor";
    private static String description = "An implementatin of the de.nece.ccrle.docmonitor.DocMonitor class from C&C Research Laboritory of NEC Europe Ltd.";
    private DocMonitor dm = null;

    /**
     * The default constructor.
     */
    public DocMonitorProvider() {
    }

    public String getProviderName() {
        return name;
    }

    // The version information is stored in the jar containing this
    // component.
    public String getVersion() {
        if ( version == null ){
            ResourceBundle info = (ResourceBundle)
                                        AccessController.doPrivileged(
                new PrivilegedAction() {
                    public Object run() {
                        return ResourceBundle.getBundle(
                                       "de.nece.ccrle.gemss.DocMonitor" );
                    }
                }
            );
                                                                                
            version = info.getString( "version" );
        }
        return version;
    }

    public boolean isLocal() {
        return local;
    }

    public String getDescription() {
        return description;
    }

    public String getComponentName() {
        return component;
    }

    public boolean supports( String component ) {
        if ( this.component.equals( component ) ){
                return true;
        } else {
            return false;
        }
    }


    /**
     * Returns instances of the <code>DocMonitor</code> component.
     * Applications
     * may cast the object returned from this method to the type
     * <code>DocMonitor</code>.
     *
     * @throws IOException if an error occurs during loading, initialization,
     *      or instantiation.
     */
    public Object createComponent() throws IOException {

        if ( dm == null ){

            final String gemssHome = System.getProperty( "gemss.home" );
            AccessController.doPrivileged(
                new PrivilegedAction() {
                    public Object run() {
                        System.setProperty( "docmonitor.home", gemssHome );
                        return null;
                    }
                }
            );

            try {
                dm = new DocMonitor();
            } catch ( Exception e ){
                throw new IOException( e.getMessage() );
            }

            long period;
            if ( ( period = dm.getPeriod() ) > 0 ) {
            // Start the updating thread.
                Timer timer = new Timer( true );
                timer.schedule( dm, period, period );
            } 

        }

        return dm;
    }

    /**
     * Returns instances of the <code>DocMonitor</code> component.
     * Applications
     * may cast the object returned from this method to the type
     * <code>DocMonitor</code>.
     *
     * @param sr - a {@link eu.gemss.components.ServiceRequest} object
     *      containing detailed information regarding the service being
     *      being requested.
     * @throws IOException if an error occurs during loading, initialization,
     *      or instantiation.
     */
    public Object createComponent( ServiceRequest sr ) throws IOException {
        if ( !supports( sr.getComponent() ) ) {
            throw new IOException( "Unsupported component: " +
                                                    sr.getComponent() );
        } else {
            return createComponent();
        }
    }
}
