/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.gemss;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;

import eu.gemss.components.providers.Provider;
import eu.gemss.components.Configuration;
import eu.gemss.components.ServiceRequest;

/**
 * Provides <code>Configuration</code> implementations.
 *
 * @author Greg Kohring
 */
public class ConfigurationProvider implements Provider {
                                                                                
    private static boolean local = true;
    private static String name = "de.nece.ccrle.ConfigurationProvider";
    private static String version = null;
    private static String component = "eu.gemss.components.Configuration";
    private static Class implementation = 
                            de.nece.ccrle.gemss.ConfigurationImpl.class;
    private static String description = "An implementatin of the eu.gemss.components.Configuration class from C&C Research Laboritory of NEC Europe Ltd.";

    /**
     * The default constructor.
     */
    public ConfigurationProvider() {
    }

    public String getProviderName() {
        return name;
    }

    // The version information is stored in the jar containing this
    // component.
    public String getVersion() {
        if ( version == null ){
            ResourceBundle info = (ResourceBundle)
                                        AccessController.doPrivileged(
                new PrivilegedAction() {
                    public Object run() {
                        return ResourceBundle.getBundle(
                                       "de.nece.ccrle.gemss.Configuration" );
                    }
                }
            );
                                                                                
            version = info.getString( "version" );
        }
        return version;
    }

    public boolean isLocal() {
        return local;
    }

    public String getDescription() {
        return description;
    }

    public String getComponentName() {
        return component;
    }

    public boolean supports( String component ) {
        if ( this.component.equals( component ) ){
                return true;
        } else {
            return false;
        }
    }

    /**
     * Returns instances of the <code>Configuration</code> component. 
     * Applications
     * may cast the object returned from this method to the type
     * <code>Configuration</code>.
     *
     * @throws IOException if an error occurs during loading, initialization,
     *      or instantiation.
     */
    public Object createComponent() throws IOException {
        Object obj = null;
        try {
            obj = implementation.newInstance();
        } catch ( Exception e ){
            throw new IOException( e.getMessage() );
        }
        return obj;
    }

    /**
     * Returns instances of the <code>Configuration</code> component. 
     * Applications
     * may cast the object returned from this method to the type
     * <code>Configuration</code>.
     *
     * @param sr - a {@link eu.gemss.components.ServiceRequest} object
     *      containing detailed information regarding the service being
     *      being requested.
     * @throws IOException if an error occurs during loading, initialization,
     *      or instantiation.
     */
    public Object createComponent( ServiceRequest sr ) throws IOException {
        if ( !supports( sr.getComponent() ) ) {
            throw new IOException( "Unsupported component: " +
                                                    sr.getComponent() );
        } else {
            return createComponent();
        }
    }
}
