/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.organizer;

import java.util.Set;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.net.URI;

/**
 * A repository for storing and managing class loaders. A class loader will
 * generally be responsible for managing the classes corresponding to a
 * single component, though it could manage a boundle of related components.
 *
 * @author Greg Kohring
 */
public interface LoaderRepository {

    /**
     * Retrieves the class loader identified by the specified id.
     *
     * @param loaderID the id of the class loader to be returned
     * @return the <code>ClassLoader</code> for
     *      the specified loaderID or null if the specified id is not
     *      in use.
     */
    public ClassLoader getClassLoader( String loaderID );

    /**
     * Retrieves a collection of all class loaders in this
     * repository.
     *
     * @return a <code>Collection</code> containing 
     *      <code>ClassLoader</code>s for
     *      the components in this repository.
     */
    public Collection getClassLoaders();

    /**
     * Retrieves this repository's id for the specified class loader.
     *
     * @param loader the <code>ClassLoader</code> whose ID is to be returned.
     * @return a <code>String</code> containing this repository's id for
     *      the specified loader or <code>null</code> if the loader is not
     *      known to this repository.
     */
    public String getLoaderID(ClassLoader loader);
}
