/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.organizer;

import java.util.Collection;

import eu.gemss.signals.Signal;

/**
 * A signal indicating that a repository has changed.
 *
 * @author Greg Kohring
 */
class RepositoryChangedSignal extends Signal {

    // a collection of changed class loaders
    private Collection changed = null;

    /**
     * The type of signal.
     */
    public static String SIGNAL_TYPE = "de.nece.ccrle.RepositoryChangedSignal";

    /**
     * A public constructor.
     *
     * @param source An object identifing the source of the signal.
     */
    public RepositoryChangedSignal( LoaderRepository source, 
                                            Collection changed ){
        super( source );
        this.changed = changed;
    }

    /**
     * Retrieves the signal type for this signal.
     *
     * @return a <code>String</code> identifying the type of signal.
     */
    public String getSignalType() {
        return SIGNAL_TYPE;
    }

    /**
     * Retrieves a collection containing those class loaders in the repository
     * which have changed since the repository was created, or since the last 
     * time this signal was emitted.
     *
     * @return a <code>Collection</code> contianing those class loaders which
     *      have changed.
     */
    public Collection getChanged() {
        return changed;
    }

    /**
     * Retrieves the repository which was changed. This is a convenience
     * function for the underlying <code>getSource()</code> method which
     * returns an object.
     *
     * @return the <code>Repository</code> whose contents were changed.
     */
    public LoaderRepository getRepository() {
        return (LoaderRepository) getSource();
    }

}
