/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.organizer;

import java.io.File;
import java.util.Date;
import java.util.Map;

/**
 * An interface to a session object.  A session object contains all the
 * active, serializable components.
 *
 *
 * @author Greg Kohring
 */
public interface Session extends Map {

    /**
     * Retrieves the session id for this session.
     *
     * @return a <code>String</code> containing the session ID for this 
     *      session. 
     */
    public String getSessionID();

    /**
     * Retrieves the date when this session was was last modified.<p> 
     *
     * @return a <code>long</code> value representing the time the 
     *      session was last modified, measured in milliseconds since the 
     *      epoch (00:00:00 GMT, January 1, 1970), or 0L if this is a new
     *      session.
     */
    long lastModified();
}
