/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.plugins.util;

import java.io.File;

import eu.gemss.components.util.Archive;
import eu.gemss.components.util.ZipArchive;
import eu.gemss.components.util.ZipArchiver;
import java.io.IOException;

/**
 * An implementation of the <code>Archive</code> component.
 *
 * @see eu.gemss.components.util.Archive
 *
 * @author Greg Kohring
 */
public class ArchiveImp implements Archive {

    public ArchiveImp() {
    }

    public ZipArchive openZipArchive( File zipFile ) throws IOException  {
        return new ZipArchiveImp( zipFile );
    }

    public ZipArchive openZipArchive( String zipFilename ) throws IOException {
        return new ZipArchiveImp( zipFilename );
    }

    public ZipArchiver createZipArchive( String zipFilename )  
                throws IOException {
        return new ZipArchiverImp( zipFilename );
    }

    public ZipArchiver createZipArchive( File zipFile )  throws IOException {
        return new ZipArchiverImp( zipFile );
    }

}
