/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.plugins.util;

import java.io.IOException;

import eu.gemss.components.providers.Provider;
import eu.gemss.components.ServiceRequest;

/**
 * A factory for creating <code>Archive</code> instances.
 * <p>
 *
 * @see eu.gemss.components.util.Archive
 *
 * @author Greg Kohring
 */
public class ArchiveProvider implements Provider {

    private static boolean local = true;
    private static String name = "de.nece.ccrle.ArchiveProvider";
    private static String version = "0.1";
    private static String component = "eu.gemss.components.util.Archive";
    private static String description = "An implementatin of the eu.gemss.components.util.Archive class.";

    /** @link dependency */
    /*# ArchiveImp lnkArchiveImpl; */

    public ArchiveProvider() {
    }

    public String getProviderName() {
        return name;
    }

    public String getVersion() {
        return version;
    }

    public boolean isLocal() {
        return local;
    }

    public String getDescription() {
        return description;
    }

    public String getComponentName() {
        return component;
    }

    public boolean supports( String component ) {
        return component.equals( this.component );
    }

    /**
     * Returns instances of the <code>Archive</code> component. Applications
     * may cast the object returned from this method to the type
     * <code>Archive</code>.
     * 
     * @throws IOException if an error occurs during loading, initialization,
     *      or instantiation.
     */
    public Object createComponent() throws IOException {
        return new ArchiveImp ();
    }

    /**
     * Returns instances of the <code>Archive</code> component. Applications
     * may cast the object returned from this method to the type
     * <code>Archive</code>.
     * 
     * @param sr - a {@link eu.gemss.components.ServiceRequest} object 
     *      containing detailed information regarding the service being 
     *      being requested. 
     * @throws IOException if an error occurs during loading, initialization,
     *      or instantiation.
     */
    public Object createComponent( ServiceRequest sr ) throws IOException {
        if ( !supports( sr.getComponent() ) ){
            throw new IOException( "Unsupported component: " +
                                                    sr.getComponent() );
        } else {
            return createComponent();
        }
    }
}
