/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.sandbox;

import java.security.KeyStore;
import java.security.cert.PKIXParameters;

/**
 * A collection of useful constants for working with X509 Certificates.
 *
 * @author Greg Kohring
 */
interface X509Constants {
    /**
     * OID for key usage.
     */
    public static final String KEY_USAGE = "2.5.29.15";

    /**
     * OID for extended key usage.
     */
    public static final String EXTENDED_KEY_USAGE = "2.5.29.37";

    /**
     * OID for extended server authorization.
     */
    public static final String SERVER_AUTH = "1.3.6.1.5.5.7.3.1";

    /**
     * OID for client authorization.
     */
    public static final String CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";

    /**
     * OID for code signing.
     */
    public static final String CODE_SIGNING = "1.3.6.1.5.5.7.3.3";

    /**
     * OID for email protection.
     */
    public static final String EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";

    /**
     * OID for time stamping.
     */
    public static final String TIME_STAMPING = "1.3.6.1.5.5.7.3.8";

    /**
     * OID for the NetscapeCertType
     */
    public static final String NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";

    /**
     * sslClient bit in the NetscapeCertType bit string.
     */
    public static final int SSL_CLIENT      = (1 << 7);

    /**
     * sslServer bit in the NetscapeCertType bit string.
     */
    public static final int SSL_SERVER       = (1 << 6);

    /**
     * smime bit in the NetscapeCertType bit string.
     */
    public static final int SMIME             = (1 << 5);

    /**
     * objectSigning bit in the NetscapeCertType bit string.
     */
    public static final int OBJECT_SIGNING     = (1 << 4);

    /**
     * sslCA bit in the NetscapeCertType bit string.
     */
    public static final int SSL_CA             = (1 << 2);

    /**
     * smimeCA bit in the NetscapeCertType bit string.
     */
    public static final int SMIME_CA             = (1 << 1);

    /**
     * objectSigningCA bit in the NetscapeCertType bit string.
     */
    public static final int OBJECT_SIGNING_CA     = (1 << 0);
}
