/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package de.nece.ccrle.security;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

/**
 * A class implmenting a Basic Authentication scheme.
 *
 * @author Greg Kohring
 */
public class BasicAuthenticator extends Authenticator {

    private String username = "";
    private char password[] = null;

    /**
     * The basic constructor.
     * 
     * @param username a <code>String</code> containing the user's name.
     * @param password a <code>String</code> containing the user's password.
     */
    public BasicAuthenticator( String username, String password ){
            this.username = username;
            this.password = password.toCharArray();
    }

    /**
     * Retrieves the password authentication
     * 
     * @return a <code>PasswordAuthentication</code> structure containing
     *      the username and password for this Authenticator.
     */
    protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication( this.username, this.password );
    }

}
