/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package de.nece.ccrle.security;

import java.io.IOException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;


/**
 * An class for managing an SSL client. The <code>NaiveSSLClient</code> will
 * make SSL connections with any server presenting a valid X509 server
 * certificate.  The certificate does not necessarily have to be present in
 * the systems trust store.
 *
 * @author Greg Kohring
 */
public class NaiveSSLClient extends SSLClient{

    /**
     * The constructor.
     * 
     */
    public NaiveSSLClient(){
    }

    /**
     * Retrieves the default <code>SSLSocketFactory</code>.
     * 
     * @return an <code>SSLSocketFactory</code> object.
     */
    public SSLSocketFactory getSSLSocketFactory() 
                throws IOException, GeneralSecurityException {
        KeyManager []km = null;
        TrustManager []tma = { new NaiveX509TrustManager() };
        SSLContext sc = SSLContext.getInstance( "ssl" );
        sc.init( km, tma, new SecureRandom() );
        return sc.getSocketFactory();
    }

}
