/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package de.nece.ccrle.security;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;



/**
 * A naive trust manager for X509 certificate chains. This 
 * <code>X509TrustManager</code> will trust any non-empty certificate chain. 
 *
 * @author Greg Kohring
 */
public class NaiveX509TrustManager implements X509TrustManager {

    /**
     * Checks whether or not the client certificate chain can be trusted. 
     * In the naive case, any non-null certificate chain is trusted.
     * 
     * @param chain the x509 peer certificate chain
     * @param authType the authentication type based on the client certificate 
     * @throws IllegalArgumentException if null or zero-length chain is 
     *      passed in for the chain parameter or if null or zero-length 
     *      string is passed in for the authType parameter
     * @throws CertificateException if the certificate chain is not 
     *      trusted by this TrustManager.
     */
    public void checkClientTrusted( X509Certificate[] chain, String authType )
                            throws CertificateException {
        if ( (chain == null) || ( chain.length == 0 ) ){
            throw new IllegalArgumentException( 
                            " invalid certificate chain! "); 
        }
        if ( (authType == null) || ( authType.length() == 0 ) ){
            throw new IllegalArgumentException( 
                            " invalid authType! "); 
        }
    }

    /**
     * Checks whether or not the server certificate chain can be trusted. 
     * In the naive case, any non-null certificate chain is trusted.
     * 
     * @param chain the x509 peer certificate chain
     * @param authType the authentication type based on the client certificate 
     * @throws IllegalArgumentException if null or zero-length chain is 
     *      passed in for the chain parameter or if null or zero-length 
     *      string is passed in for the authType parameter
     * @throws CertificateException if the certificate chain is not 
     *      trusted by this TrustManager.
     */
    public void checkServerTrusted( X509Certificate[] chain, String authType )
                            throws CertificateException {
        if ( (chain == null) || ( chain.length == 0 ) ){
            throw new IllegalArgumentException( 
                            " invalid certificate chain! "); 
        }
        if ( (authType == null) || ( authType.length() == 0 ) ){
            throw new IllegalArgumentException( 
                            " invalid authType! "); 
        }
    }

    /**
     * Returns an array of certificate authority certificates which are 
     * trusted for authenticating peers.
     *
     * @return a non-<code>null</code> (possibly empty) array of acceptable 
     *      CA issuer certificates.
     */
    public X509Certificate[] getAcceptedIssuers(){
        return new X509Certificate[0];
    }

}
