/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package de.nece.ccrle.util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

/**
 * A file change listener.
 *
 * @author Greg Kohring
 */
public interface FileChangeListener extends EventListener {
    /**
     * This method will be called when there are any changes to 
     * the file or directory being monitored.
     *
     * @param file a <code>List</code> of <code>File</code> objects 
     *      denoting files which have changed during
     *      the last monitoring period.
     */
    void changed( List file );

    /**
     * This method will be called when there are any additions to 
     * the directory being monitored.
     *
     * @param file a <code>List</code> of <code>File</code> objects 
     *      denoting files which have been added during
     *      the last monitoring period.
     */
    void added( List file );

    /**
     * This method will be called when there are any deletions from 
     * the directory being monitored.
     *
     * @param file a <code>List</code> of <code>File</code> objects 
     *      denoting files which have been deleted during
     *      the last monitoring period.
     */
    void deleted( List file );
}


