/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss;

/**
 * The class FatalGridException and its subclasses indicate that a
 * fatal condition within the component framework has arisen.
 * Once such a condition has arisen it may be impossible to continue. 
 *
 */
public class FatalGridException extends GridException {

    /**
     * Creates a new FatalGridException with default
     * user and system messages.
     */
    public FatalGridException() {
        super( "A fatal error has occurred within some component", 
                "A fatal exception has occured." );
    }

    /**
     * Creates a new FatalGridException with the specified
     * user and system messages.
     *
     * @param userMsg a <code>String</code> containing a message intended
     *      for the user.
     * @param systemMsg a <code>String</code> containing a message intended
     *      for the system administrator or application developer.
     */
    public FatalGridException( String userMsg, String systemMsg ) {
        super( userMsg, systemMsg );
    }
}
