/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss;

/**
 * The class ComponentException and its subclasses indicate 
 * conditions within the component framework that a reasonable application 
 * might want to catch. This class provides for differentiated messaging,
 * depending upon the intended recipient. For example, user messages may
 * indicate conditions in terms a layman would understand, while system
 * message may indicate the same condition in terms which might help the
 * system administrator to take appropriate action.
 *
 */
public class GridException extends Exception {

    private String userMsg   = "";
    private String systemMsg = "";

    /**
     * Creates a new ComponentException with <code>null</code> as its
     * user and system messages.
     */
    public GridException() {
    }

    /**
     * Creates a new ComponentException with the specified 
     * user and system messages.
     *
     * @param userMsg a <code>String</code> containing a message intended
     *      for the user.
     * @param systemMsg a <code>String</code> containing a message intended
     *      for the system administrator or application developer.
     */
    public GridException(String userMsg, String systemMsg) {
        super( userMsg );
        this.userMsg = userMsg;
        this.systemMsg = systemMsg;
    }

    /**
     * Retrieves the user message.
     *
     * @return a <code>String</code> containing the message intended
     *      for the user.
     */
    public String getUserMessage() {
        return userMsg;
    }

    /**
     * Retrieves the system message.
     *
     * @return a <code>String</code> containing the message intended
     *      for the system administrator or application developer.
     */
    public String getSystemMessage() {
        return systemMsg;
    }
}
