/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.components;


/**
 * An interface to the local configuration file. This is a convenience
 * class which can be used by other components to reference any configuration
 * data defined in the local configuration file.
 * <p>
 * Note: This component will be created automatically when the environment
 * is initialized. Other components which need this information should
 * access this component using the main API:
 * <p>
 * <pre> 
 * Configuration config = (Configuration) GEMSS.getInstance().getInstance( "eu.gemss.components.configuration" );
 * </pre>  
 *
 */
public interface Configuration {

    /**
    * Retrieves the name of the local file backing the key store.
    *
    * @return a <tt>Sting</tt> containing the name of a local file backing
    *       the key store, or <tt>null</tt> if no default file name has been 
    *       defined.
    */
    public String getKeyStoreFilename();

    /**
    * Retrieves the type of the local file backing the key store.
    *
    * @return a <tt>Sting</tt> containing the type of key store.
    */
    public String getKeyStoreType();

    /**
    * Retrieves the name of this clients home directory
    *
    * @return a <tt>Sting</tt> containing the name of this clients
    *       home directory.
    */
    public String getHome();

    /**
    * Retrieves a string identifying the component repository.
    * The meaning of
    * this string depends upon the nature of the component store.
    *
    * @return a non-<code>null</code> <code>Sting</code> identifying 
    *       the session store.
    */
    public String getComponentStore();

    /**
    * Retrieves a string which identifies the session store. The meaning of
    * this string depends upon the nature of the session store.
    *
    * @return a <cod>String</code> which identifies the session store. A
    *   <code>null</code> value indicates the session store has not been 
    *   defined in the configuration file.
    */
    public String getSessionStore();

    /**
    * Retrieves the period of time between checks for changes to the component 
    * repository as defined in the configuration file.
    *
    * @return a <code>long</code> integer containing the interval between 
    *       checks for changes to the component repository. A value of -1
    *       indicates that the interval has not been set in the configuration
    *       file.
    */
    public long getRepositoryUpdateInterval();

    /**
    * Retrieves the location of the directory containing configuration files.
    *
    * @return a non-null <code>String</code> containing the name of the 
    *       directory containing the configuration files.
    */
    public String getConfigDir();

    /**
    * Retrieves a list of fully qualified component names which should be
    * started as daemons when the component manager is initialized.
    *
    * @return a <code>String</code> array containing fully qualified names of
    *       the daemon components to be
    *       started by the component manager.
    */
    public String[] getDaemons();
}

