/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package eu.gemss.components;

import eu.gemss.GridException;

/**
 * An excption thrown when an invalid <code>ServiceRequest</code> object 
 * is submitted to the component manager.
 */
public class InvalidRequestException extends GridException {
    /**
     * Creates a new InvalidRequestException with the specified
     * user and system messages.
     *
     * @param userMsg a <code>String</code> containing a message intended
     *      for the user.
     * @param systemMsg a <code>String</code> containing a message intended
     *      for the system administrator or application developer.
     */
    public InvalidRequestException( String userMsg, String systemMsg ) {
        super( userMsg, systemMsg );
    }

    /**
     * Creates a new InvalidRequestException with default
     * user and system messages.
     */
    public InvalidRequestException() {
        super( "The submitted request is invalid.", 
                "The submitted request is invalid." );
    }
}
