/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.components;

/**
 * This class, and its subclasses, provide a means for requesting services 
 * from a provider with some specific properties.
 *
 * @see eu.gemss.components.providers.Provider
 */
public class ServiceRequest {

    private String component = null;
    private String providerName = null;
    private String version = null;

    /**
     * Create a new Service Request for the specified component and provider.
     *
     * @param component a <code>String</code> containing the name of the
     *      component for whom this request is being created.
     * @param providerName a <code>String</code> containing the name of the
     *      desired provider. This should be the same name as that
     *      returned by the
     *      {@link eu.gemss.components.providers.Provider#getProviderName()}
     *      method.  If <code>null</code>, an arbitrary provider
     *      will be selected.
     * @param version a <code>String</code> containing the version of the
     *      requested component. This should be the same value as
     *      that returned by the
     *      {@link eu.gemss.components.providers.Provider#getVersion()}
     *      method.  If <code>null</code>, an arbitrary version
     *      will be selected. 
     *
     * @see eu.gemss.components.providers.Provider
     */
    public ServiceRequest( String component, String providerName, 
                           String version ) {
        this.component = component;
        this.providerName = providerName;
        this.version = version;
    }

    /**
     * Retrieves the name of the component being requested.
     * 
     * @return a <code>String</code> containing the fully qualified name of
     *      the component being requested.
     */
    public String getComponent(){
            return component;
    }

    /**
     * Retrieves the name of the component provider.
     * 
     * @return a <code>String</code> containing the name of
     *      the component provider. 
     */
    public String getProviderName(){
            return providerName;
    }

    /**
     * Retrieves the version of the requested component.
     * 
     * @return a <code>String</code> containing the version of
     *      the requested component. 
     */
    public String getVersion(){
            return version;
    }

}
