/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.components;
/**
 * An interface for marking components which require explicit termination.
 * The terminable interface gives components a chance to perform any 
 * necessary clean-up
 * operations before the component is released for finalization.<p>
 *
 */
public interface Terminable {
    /**
    * Terminates the component. This method must be called explicitly by 
    * the controlling application.
    * <p>
    * Any components which run as daemons should return from their run() method
    * when this method is called.
    * <p>
    * <strong>NOTE: </strong> Components should not depend upon this method
    * being called because the application itself might exit before this
    * method is invoked. In other words, when the component is initialized
    * the next time the application is started, its new state should not 
    * depend upon this function having been called when the application last
    * exited.
    */
    public void terminate();
}
