/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/08/13 10:55:29 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////
package eu.gemss.components.discovery;


import java.util.Set; 
import java.util.List;


/**
 * 	This interface defines the main operations provided by the Discovery
 *	component. This includes initialization of the component, querying 
 *	remote registries and retrieving the results of the queries.
 */

public abstract class Discovery {

    /**
     * 	Initializes the Discovery component. The set of URIs (endpoints) 
     *	of remote registry services is given by the config/registry.properties
     *	file.
     * 
     *    @throws eu.gemss.components.discovery.DiscoveryGridException
     */
    public abstract void init() throws DiscoveryGridException;
	
    /**
     * 	This method queries remote registry services for all services that
     *	matches the given attributes and returns <code>List</code> 
     *	of {@link ServiceDescription}. <p>
     *	Each returned Service object consists at least a service enpoint URI
     *	as well as optional attributes.
     *	Attributes are arbitrary name-value pairs for providing advanced 
     *	information on GEMSS services. <p> 
     * 
     *    @throws eu.gemss.components.discovery.DiscoveryGridException
     *    @throws eu.gemss.components.discovery.RegistryGridException
     *    @return {@link List} 
     */
    public abstract List discoverServices(Attribute[] attributes) throws DiscoveryGridException, RegistryGridException; 
    
    /**
     * 	Returns a <code>List</code> of {@link ServiceDescription} objects. Each Service
     *	object consists at least a service enpoint URI as well as optional
     *	attributes (arbitrary name/value pairs).
     * 
     * @return List
     */ 
    // public abstract List getServices();
     
}

