/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/08/13 10:55:29 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////
package eu.gemss.components.discovery;


/**
 * This class comprises basic information about a GEMSS
 * Application Service including a mandatory WSDL endpoint URI
 * and an optional set of attributes. Basic access methods
 * (get/set) are provided in order to manipulate ServiceDescription
 * objects. All attributes are stored in an array of Attribute objects.
 */  
public class ServiceDescription implements java.io.Serializable {
    
    protected Attribute[] attributes;
    protected String      wsdlEndpoint;

    /**
     * Constructs an empty service object.
     */
    public ServiceDescription() {
      
        attributes = null;
        wsdlEndpoint = null;  
    }

    /**
     * Returns an array of <code> Attribute</code> (arbitrary name/value pairs)
     * for this ServiceDescription.
     */	
    public Attribute[] getAttributes() {
        return attributes;
    }

    /**
     * Sets all attributes (arbitrary name/value pairs) for
     * this ServiceDescription with the given array Attribute.
     */ 
    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    /**
     * Returns the WSDL endpoint URI of this ServiceDescription.
     * 
     * @return {@link String}
     */
    public java.lang.String getWsdlEndpoint() {
        return wsdlEndpoint;
    }

    /**
     * Sets the WSDL endpoint URI of the ServiceDescription.
     */    
    public void setWsdlEndpoint(java.lang.String wsdlEndpoint) {
        this.wsdlEndpoint = wsdlEndpoint;
    }

}
