/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.negotiation;

import eu.gemss.components.negotiation.NegotiationException;

/**
 * The class NoCFPsSentException is thrown by the QoS negotiation component
 * when none of the CFP messages get through. If no service providers receive
 * a CFP then they cannot be expected to provide proposals and the auction will
 * have to either finish or re-send the CFPs.
 */
public class NoCFPsSentException extends NegotiationException {

	/**
     * Creates a new NoCFPsSentException with the specified
     * user and system messages.
     * @param userMsg a <code>String</code> containing a message intended for the user.
     * @param systemMsg a <code>String</code> containing a message intended for the system administrator or application developer.
     */
    public NoCFPsSentException( String userMsg, String systemMsg ) {
        super( userMsg,systemMsg );
    }
}
