/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.negotiation;

import eu.gemss.components.negotiation.NegotiationException;
import java.util.Vector;

/**
 * The class ParticipantsNotReady is thrown by the QoS negotiation component
 * when some, or all, of the GEMSS proxy objects fail to respond to the start
 * auction messages. The client can either retry later or use a different selection
 * of service providers.
 */
public class ParticipantsNotReadyException extends NegotiationException {

	// vector of GEMSS proxy objects that are not ready
	private Vector mvectorProxies;

	/**
     * Creates a new ParticipantsNotReadyException with the specified
     * user and system messages.
     * @param userMsg a <code>String</code> containing a message intended for the user.
     * @param systemMsg a <code>String</code> containing a message intended for the system administrator or application developer.
     */
    public ParticipantsNotReadyException( String userMsg, String systemMsg, Vector vectorProxies ) {
        super( userMsg,systemMsg );
		mvectorProxies = vectorProxies;
    }

	/**
     * get the proxies that are not ready
     * @return a vector of GEMSSProxy objects which were not ready to start the auction
     */
    public Vector getProxies() {
        return mvectorProxies;
    }
}
