/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.negotiation;

import eu.gemss.components.ServiceRequest;

/**
 * This class provides a means for requesting a negotiation component
 */
public class QoSNegotiationRequest extends ServiceRequest {
    // member data
	private String mstrConfigFile;

    /**
     * Create a new Service Request for the specified component and provider.
     * @param strConfigFile filename where negotiation config data is held
     * @param component a <code>String</code> containing the name of the
     *      component for whom this request is being created.
     * @param providerName a <code>String</code> containing the name of the
     *      desired provider. If <code>null</code>, an arbitrary provider
     *      will be selected.
     * @param strVersion a <code>String</code> containing the version of the
     *      requested component. This should be the same value as
     *      that returned by the
     *      {@link eu.gemss.components.providers.Provider#getVersion()}
     *      method.  If <code>null</code>, an arbitrary version
     *      will be selected.
     */
	public QoSNegotiationRequest( String strConfigFile, String component, String providerName, String strVersion )
	{
		super( component,providerName,strVersion );
		mstrConfigFile = strConfigFile;
	}

	/**
	 * Retrieves the config file, if there is one. If not null will be returned and the other
	 * attributes will be set instead
	 * @return a <code>String</code> containing the filename
	 */
	public String getConfigFile() { return mstrConfigFile; }

}