/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.negotiation;

import java.util.Vector;
import java.util.Hashtable;
import java.io.Serializable;

/**
 * This interface defines the QoSRequirements. This is simply a "name"/"property list" pair hash table.
 */
public interface QoSRequirements extends Serializable {

	/**
     * Add a QoS property to the list. Each property has a name, importance weighting and values for min/max.
	 * Null values can be passed, and if they are the min/max values will be ignored.
	 * @param strQoSParameterName name of the QoS parameter
	 * @param vectorProperties vector of objects for this parameter. The object types can be defined by the user.
     */
	public void addQoSProperty( String strQoSParameterName, Vector vectorProperties ) throws Exception;

	/**
     * Returns the current set of QoS properties names and values.
	 * @return hash table containing the QoSParameterName's as a key's, and property vector as contents
     */
	public Hashtable getQoSProperties() throws Exception;
}
