/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */


package eu.gemss.components.providers;

/**
 * An optional interface which may be implemented by any object which is
 * to be placed in the component registry.
 * <p>
 * This interface can be used for many purposes, one of which is to allow 
 * the providers the opportunity
 * to check for the existence of any runtime licenses. From the application's
 * viewpoint, it is better to
 * make such checks at registration rather than at the time the
 * implementing class is initialized as it avoids the necessity of taking 
 * into consideration providers for whom no runtime licenses are available.
 *
 */
public interface Registrable {

    /**
     * Called when the object is registered with the named registry.
     *
     * @param registryID the identifier for the registry in which 
     *      this item has been registered.
     * @return <tt>true</tt> if this object agrees to be registered in
     *        the specified registry. If this method returns <tt>false</tt>
     *        then the object should not be registered.
     */
    boolean onRegistration( String registryID );

    /**
     * Called when the object is deregistered from the named registry.
     *
     * @param registryID the identifier of the registry in which this 
     *      item had been registered.
     */
    void onDeregistration( String registryID );


}
