/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.proxies;

import java.io.File;
import org.w3c.dom.Document;
import eu.gemss.GridException;

/**
 * This interface defines the set of job handling common methods which all GEMSS services
 * are required to implement.
 */
public interface GEMSSJobHandlingProxy {
	// Proxy flags
	public final static String mstaticUploadCompleteFlag = "GEMSSProxy-UploadComplete";
	public final static String mstaticJobStartedFlag = "GEMSSProxy-JobStarted";
	public final static String mstaticJobFinishedFlag = "GEMSSProxy-JobFinishedComplete";
	public final static String mstaticJobFailedFlag = "GEMSSProxy-JobFailedComplete";
	public final static String mstaticJobKilledFlag = "GEMSSProxy-JobKilledComplete";
	public final static String mstaticFinalDownloadCompleteFlag = "GEMSSProxy-FinalDownloadComplete";
	public final static String mstaticAcknowledgementSentFlag = "GEMSSProxy-AcknowledgementSent";

    /**
     * Starts the job. A ConversationException will be throwm if this function
     * is called before the job conversation is ready.
     * This method will block.
     */
    public void start() throws GridException;

    /**
     * Uploads data from the provided file to the Grid server.
     * A ConversationException will be throwm if this function is called
     * before the job conversation is ready.
     * This method will block.
     * @param inputArchiveFilename the name of the archive file containing the data to
     *      be uploaded.
     */
    public void uploadData( String inputArchiveFilename ) throws GridException;

    /**
     * Downloads the result data for a job. A GridException will be
     * throwm if this function is called before the job conversation is ready.
     * This method will block.
     * @param filename File to download, which will be archived by the application archive script.
     * If the empty string is used then the proxy will set the "FinalDownloadComplete" flag and ask
     * for all result files to be archived.
     * @param outputArchiveFilename filename of the output archive where the resulting downloaded archive can be saved.
     */
    public void downloadData( String filename, String outputArchiveFilename ) throws GridException;

    /**
     * Retrieves the job status. A GridException will be throwm if
     * this function is called before the job conversation is ready.
     * This method will block.
     * @return a string containing the result of the application's getStatus script. The exact
     * contents of this script are specific to each application, but will be defined in one of the GEMSS
     * project design documents. Special values are "FINISHED", "KILLED" and "FAILED", which will
     * cause the appropriate flags to be set in the proxy.
     */
    public String getStatus() throws GridException;

    /**
     * Kills the running job. A GridException will be throwm if this
     * function is called before the job conversation is ready.
     * This method will block.
     */
    public void kill() throws GridException;

    /**
     * Acknowledge results. This methods can be called when the client is happy with the results
     * downloaded, and wants the service provider to end the job. The service provider will delete
     * all traces of data from the server side, important when dealing with medical data etc.
     * This method will block.
     */
   public void acknowledgeResults() throws GridException;
}
