/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.proxies;

import eu.gemss.components.proxies.GEMSSJobHandlingProxy;
import eu.gemss.components.Terminable;
import eu.gemss.GridException;
import java.util.Vector;

/**
 * This interface defines the set of common negotiation methods which all GEMSS services
 * are required to implement.
 */
public interface GEMSSNegotiator extends Terminable, GEMSSJobHandlingProxy {
	// Negotiator flags (used in addition to GEMSSProxy flags)
	public final static String mstaticNegotiatorHaltedFlag = "GEMSSNegotiator-NegotiatorHalted";
      public final static String mstaticAuctionStartedFlag = "GEMSSProxy-AuctionStarted";
      public final static String mstaticQoSPropertiesObtainedFlag = "GEMSSProxy-QoSPropertiesObtained";
      public final static String mstaticBiddingFinishedFlag = "GEMSSProxy-BiddingFinished";
      public final static String mstaticAuctionEndedFlag = "GEMSSProxy-AuctionEnded";

    /**
     * Return a vector of proxy flags. The flag values are held in the GEMSSNegotiationProxy and
     * GEMSSJobHandlingProxy interfaces
     * @return vector of flag strings
     */
   public Vector getNegotiatorFlags();

   /**
    * Return the negotiator's GridException, if any, that is recorded when the negotiator
    * is halted and the GEMSSNegotiator.mstaticNegotiatorHaltedFlag flag is set. If there is
    * no exception, or the negotiator is not halted, then a null is returned.
    * @return GridException type that halted the negotiator (or null if there is none)
    */
   public GridException getNegotiatorException();

   /**
    * Return the number of parties in the current negotiation. This will be 1 after a proxy is bound, or zero
    * if the negotiation failed.
    * @return number of parties (proxies)
    */
   public int queryNumberOfParties();

   /**
    * Return the current bidding round for the negotiation (auction). The final round is returned if the auction has ended.
    * @return current auction round number
    */
   public long queryAuctionRound();
}
