/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.proxies;

import eu.gemss.components.ServiceRequest;

/**
 * This class provides a means for requesting negotiator services with some specific
 * properties about the end point.
 */
public class GEMSSNegotiatorRequest extends ServiceRequest {

	private String mstrRequestDescFilename;
      private String mstrServiceName;
      private String mstrQoSConfigFile;
	private String mstrProxyConfigFile;

    /**
     * Create a new Service Request for the specified component and provider. This constructor sets the end
     * point explicitly, thus forcing the negotiator to bypass the negotiation step and use the service
     * explicitly provided in these parameters.
     * If the proxy end point is specified, no negotiation or discovery occurs. If the negotiation config is
     * specified then a QoS auction is conducted with all discovered services. If the neg config file is not
     * provided the app/user is asked via a signal to select a service from the discovery list.
     * @param strRequestDescFilename filename of the application specific description of the input data characteristics.
     * @param strServiceName name of the service required
     * @param strQoSConfigFile QoSNegotiation configuration file required to setup the negotiation (auction) parameters.
     * If null a select service signal will be fired to let the application/user manually select a service.
     * @param strProxyConfigFile GEMSSProxy configuration file containing end point info. If null the negotiation component
     * and discovery component will be invoked to select a service and get the end point information from the service registry metadata.
     * @param component a <code>String</code> containing the name of the
     *      component for whom this request is being created.
     * @param providerName a <code>String</code> containing the name of the
     *      desired provider. If <code>null</code>, an arbitrary provider
     *      will be selected.
     * @param strVersion a <code>String</code> containing the version of the
     *      requested component. This should be the same value as
     *      that returned by the
     *      {@link eu.gemss.components.providers.Provider#getVersion()}
     *      method.  If <code>null</code>, an arbitrary version
     *      will be selected.
     */
	public GEMSSNegotiatorRequest( String strRequestDescFilename, String strServiceName, String strQoSConfigFile, String strProxyConfigFile, String component, String providerName, String strVersion )
	{
		super( component,providerName,strVersion );
		mstrRequestDescFilename = strRequestDescFilename;
            mstrServiceName = strServiceName;
            mstrQoSConfigFile = strQoSConfigFile;
		mstrProxyConfigFile = strProxyConfigFile;
	}

	/**
	 * Retrieves the request descriptor
	 * @return a filename to the request descriptor file
	 */
	public String getRequestDesc() { return mstrRequestDescFilename; }

      /**
       * Retrieves the required service's name
       * @return a <code>String</code> containing the service name
       */
      public String getServiceName() { return mstrServiceName; }

      /**
       * Retrieves the QoSNegotiation config file. If null a signal will be fired to
       * ask for manual service selection.
       * @return a <code>String</code> containing the QoSNegotiation config filename
       */
      public String getQoSConfigFile() { return mstrQoSConfigFile; }

	/**
	 * Retrieves the GEMSSProxy config file. If null discovery will occur
	 * @return a <code>String</code> containing the GEMSSProxy config filename
	 */
	public String getProxyConfigFile() { return mstrProxyConfigFile; }
}