/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.proxies;

import java.io.File;
import java.util.Vector;
import org.w3c.dom.Document;

import eu.gemss.components.Terminable;
import eu.gemss.components.proxies.GEMSSJobHandlingProxy;
import eu.gemss.components.proxies.GEMSSNegotiationProxy;

/**
 * This interface defines the set of common methods which all GEMSS services
 * are required to implement. It inherits from the negotiation and job handling
 * proxy interfaces.
 */
public interface GEMSSProxy extends Terminable, GEMSSJobHandlingProxy, GEMSSNegotiationProxy {
      /**
       * Return the proxies current status flags. Flags are defined in both the GEMSSNegotiationProxy and
       * GEMSSJobHandlingProxy interfaces.
       * @return Vector of flag strings that are currently set
       */
      public Vector getProxyFlags();

      /**
       * Return the job CID, if there is one. If not null is returned.
       * @return job conversation ID
       */
      public String queryJobConversationID();

      /**
       * Return the negotiation CID, if there is one. If not null is returned.
       * @return neg conversation ID
       */
      public String queryNegConversationID();

      /**
       * Return the account CID, if there is one. If not null is returned.
       * @return account conversation ID
       */
      public String queryAccountConversationID();

      /**
       * Set the account conv ID which this proxy can use. This is normally agreed offline so there will
       * not be a service provider operation to get this.
       * @param strID account conv ID
       */
      public void setAccountConversationID( String strID );

      /**
       * Set the neg conversation ID. This should only be called if the client knows the conversation ID
       * already. The getNegConvID method should normally be called to invoke the service provider
       * operation appropriate to this task.
       * @param strID account conv ID
       */
      public void setNegConversationID( String strID );

      /**
       * Set the job conversation ID. This should only be called if the client knows the conversation ID
       * already. The getJobConvID method should normally be called to invoke the service provider
       * operation appropriate to this task.
       * @param strID account conv ID
       */
      public void setJobConversationID( String strID );

}
