/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.proxies;

import org.w3c.dom.Document;
import eu.gemss.components.ServiceRequest;

/**
 * This class provides a means for requesting proxy services with the filename of the
 * config file where operation / wsdl properties can be read
 * If the config file is null the individual values have been set and should be requested
 * with the get methods provided
 */
public class GEMSSProxyRequest extends ServiceRequest {
      // member data
	private String mstrConfigFile;
	private String mstrWSDLURI;
	private String mstrServiceName;
	private String mstrEndPointPortName;
	private String mstrServicePortType;
	private String mstrBinding;

	private String mstrOpUploadData;
	private String mstrOpStart;
	private String mstrOpKill;
	private String mstrOpGetStatus;
	private String mstrOpDownload;
	private String mstrOpAcknowledgeResults;

      private String mstrOpGetWSLA;
	private String mstrOpUploadRequestDesc;
	private String mstrOpAuctionInform;
	private String mstrOpAuctionCFP;
	private String mstrOpAuctionPropose;
	private String mstrOpAuctionAcceptProposal;
	private String mstrOpAuctionRejectProposal;
	private String mstrOpAuctionRequest;
      private String mstrOpGetJobCID;
      private String mstrOpGetNegCID;

      private String mstrArgConversationID;
      private String mstrArgFilenameParam;
      private String mstrArgInputDataFileTag;
      private String mstrArgOutputDataFileTag;
      private String mstrArgAuctionMessage;

      private boolean mbUsePolicy;


    /**
     * Create a new Service Request for the specified component and provider.
     * @param strConfigFile filename where wsdl / operation details are held
     * @param component a <code>String</code> containing the name of the
     *      component for whom this request is being created.
     * @param providerName a <code>String</code> containing the name of the
     *      desired provider. If <code>null</code>, an arbitrary provider
     *      will be selected.
     * @param strVersion a <code>String</code> containing the version of the
     *      requested component. This should be the same value as
     *      that returned by the
     *      {@link eu.gemss.components.providers.Provider#getVersion()}
     *      method.  If <code>null</code>, an arbitrary version
     *      will be selected.
     */
	public GEMSSProxyRequest( String strConfigFile, String component, String providerName, String strVersion )
	{
		super( component,providerName,strVersion );
		mstrConfigFile = strConfigFile;
		mstrWSDLURI = null;
		mstrServiceName = null;
		mstrEndPointPortName = null;
		mstrServicePortType = null;
		mstrBinding = null;

		mstrOpUploadData = null;
		mstrOpStart = null;
		mstrOpKill = null;
		mstrOpGetStatus = null;
		mstrOpDownload = null;
		mstrOpAcknowledgeResults = null;

            mstrOpGetWSLA = null;
            mstrOpUploadRequestDesc = null;
            mstrOpAuctionInform = null;
            mstrOpAuctionCFP = null;
            mstrOpAuctionPropose = null;
            mstrOpAuctionAcceptProposal = null;
            mstrOpAuctionRejectProposal = null;
            mstrOpAuctionRequest = null;
            mstrOpGetJobCID = null;
            mstrOpGetNegCID = null;

		mstrArgConversationID = null;
		mstrArgFilenameParam = null;
		mstrArgInputDataFileTag = null;
		mstrArgOutputDataFileTag = null;
            mstrArgAuctionMessage = null;

            mbUsePolicy = false;
	}

	/**
	 * Create a new Service Request for the specified component and provider.
	 * @param strWSDLURI WSDL URI for this proxy to bind to
	 * @param strServiceName The name of the service
	 * @param strEndPointPortName The name of the end point port
	 * @param strServicePortType The name of the service port
	 * @param strBinding The binding type to be used
	 * @param strOpUploadData Name of the upload operation
	 * @param strOpStart Name of the start operation
	 * @param strOpKill Name of the kill operation
	 * @param strOpGetStatus Name of the get status op
	 * @param strOpDownload Name of the download op
	 * @param strOpAcknowledgeResults Name of the acknowledge results op
       * @param strOpGetWSLA Name of the get WSLA op
       * @param strOpUploadRequestDesc Name of the upload request descriptor file op
       * @param strOpAuctionInform Name of the auction inform op
       * @param strOpAuctionCFP Name of the auction call for proposals op
       * @param strOpAuctionPropose Name of the auctino propose op
       * @param strOpAuctionAcceptProposal Name of the auction accept proposal op
       * @param strOpAuctionRejectProposal Name of the auction reject proposal op
       * @param strOpAuctionRequest Name of the auction request op
       * @param strOpGetJobCID Name of the getJobCID op
       * @param strOpGetNegCID Name of the getNegCID op
	 * @param strArgConversationID Name of the conv ID argument type
	 * @param strArgFilenameParam Name of the filename argument type
	 * @param strArgInputDataFileTag Name of the input file tag argument (for SOAP attachment version of upload/download)
	 * @param strArgOutputDataFileTag Name of the output file tag argument (for SOAP attachment version of upload/download)
       * @param strArgAuctionMessage Name of the auction message tag argument
       * @param bUsePolicy flag for security policy use (false will use no policy)
	 * @param component a <code>String</code> containing the name of the
	 *      component for whom this request is being created.
	 * @param providerName a <code>String</code> containing the name of the
	 *      desired provider. If <code>null</code>, an arbitrary provider
	 *      will be selected.
	 * @param strVersion a <code>String</code> containing the version of the
	 *      requested component. This should be the same value as
	 *      that returned by the
	 *      {@link eu.gemss.components.providers.Provider#getVersion()}
	 *      method.  If <code>null</code>, an arbitrary version
	 *      will be selected.
	 */
	  public GEMSSProxyRequest( String strWSDLURI, String strServiceName, String strEndPointPortName, String strServicePortType,
                                 String strBinding,
                                 String strOpUploadData, String strOpStart, String strOpKill,
                                 String strOpGetStatus, String strOpDownload, String strOpAcknowledgeResults,
                                 String strOpGetWSLA, String strOpUploadRequestDesc, String strOpAuctionInform, String strOpAuctionCFP,
                                 String strOpAuctionPropose, String strOpAuctionAcceptProposal, String strOpAuctionRejectProposal,
                                 String strOpAuctionRequest, String strOpGetJobCID, String strOpGetNegCID,
                                 String strArgConversationID, String strArgFilenameParam, String strArgInputDataFileTag, String strArgOutputDataFileTag,
                                 String strArgAuctionMessage,
                                 boolean bUsePolicy,
					   String component, String providerName, String strVersion )
	  {
		  super( component,providerName,strVersion );
              mstrConfigFile = null; // callers can check this is null before asking for other parameters
		  mstrWSDLURI = strWSDLURI;
		  mstrServiceName = strServiceName;
              mstrEndPointPortName = strEndPointPortName;
		  mstrServicePortType = strServicePortType;
		  mstrBinding = strBinding;

		  mstrOpUploadData = strOpUploadData;
		  mstrOpStart = strOpStart;
		  mstrOpKill = strOpKill;
		  mstrOpGetStatus = strOpGetStatus;
		  mstrOpDownload = strOpDownload;
              mstrOpAcknowledgeResults = strOpAcknowledgeResults;

              mstrOpGetWSLA = strOpGetWSLA;
              mstrOpUploadRequestDesc = strOpUploadRequestDesc;
              mstrOpAuctionInform = strOpAuctionInform;
              mstrOpAuctionCFP = strOpAuctionCFP;
              mstrOpAuctionPropose = strOpAuctionPropose;
              mstrOpAuctionAcceptProposal = strOpAuctionAcceptProposal;
              mstrOpAuctionRejectProposal = strOpAuctionRejectProposal;
              mstrOpAuctionRequest = strOpAuctionRequest;
              mstrOpGetJobCID = strOpGetJobCID;
              mstrOpGetNegCID = strOpGetNegCID;

		  mstrArgConversationID = strArgConversationID;
		  mstrArgFilenameParam = strArgFilenameParam;
		  mstrArgInputDataFileTag = strArgInputDataFileTag;
		  mstrArgOutputDataFileTag = strArgOutputDataFileTag;
              mstrArgAuctionMessage = strArgAuctionMessage;

              mbUsePolicy = bUsePolicy;
	  }

	/**
	 * Retrieves the config file, if there is one. If not null will be returned and the other
	 * attributes will be set instead
	 * @return a <code>String</code> containing the filename
	 */
	public String getConfigFile() { return mstrConfigFile; }

      /**
       * Retrieves the WSDL URI, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getWSDLURI() { return mstrWSDLURI; }

      /**
       * Retrieves the service name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getServiceName() { return mstrServiceName; }

      /**
       * Retrieves the end point port, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getEndPointPortName() { return mstrEndPointPortName; }

      /**
       * Retrieves the service port, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getServicePortType() { return mstrServicePortType; }

      /**
       * Retrieves the binding, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getBinding() { return mstrBinding; }

      /**
       * Retrieves the upload operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpUploadData() { return mstrOpUploadData; }

      /**
       * Retrieves the start operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpStart() { return mstrOpStart; }

      /**
       * Retrieves the kill operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpKill() { return mstrOpKill; }

      /**
       * Retrieves the get status operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpGetStatus() { return mstrOpGetStatus; }

      /**
       * Retrieves the download operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpDownload() { return mstrOpDownload; }

      /**
       * Retrieves the getJobCId operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpGetJobCID() { return mstrOpGetJobCID; }

      /**
       * Retrieves the getNegCId operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpGetNegCID() { return mstrOpGetNegCID; }


      /**
       * Retrieves the acknoweldge results operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAcknowledgeResults() { return mstrOpAcknowledgeResults; }

      /**
       * Retrieves the get WSLA operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpGetWSLA() { return mstrOpGetWSLA; }

      /**
       * Retrieves the upload request desc operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpUploadRequestDesc() { return mstrOpUploadRequestDesc; }

      /**
       * Retrieves the auction inform operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAuctionInform() { return mstrOpAuctionInform; }

      /**
       * Retrieves the auction cfp operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAuctionCFP() { return mstrOpAuctionCFP; }

      /**
       * Retrieves the auction propose operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAuctionPropose() { return mstrOpAuctionPropose; }

      /**
       * Retrieves the auction accept proposal operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAuctionAcceptProposal() { return mstrOpAuctionAcceptProposal; }

      /**
       * Retrieves the auction reject proposal operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAuctionRejectProposal() { return mstrOpAuctionRejectProposal; }

      /**
       * Retrieves the auction request operation name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getOpAuctionRequest() { return mstrOpAuctionRequest; }

      /**
       * Retrieves the conversation arg name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getArgConversationID() { return mstrArgConversationID; }

      /**
       * Retrieves the filename param arg name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getArgFilenameParam() { return mstrArgFilenameParam; }

      /**
       * Retrieves the input data file tag arg name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getArgInputDataFileTag() { return mstrArgInputDataFileTag; }

      /**
       * Retrieves the output data file tag arg name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getArgOutputDataFileTag() { return mstrArgOutputDataFileTag; }

      /**
       * Retrieves the auction message arg name, of null if it is not set
       * @return a <code>String</code> containing the value
       */
      public String getArgAuctionMessage() { return mstrArgAuctionMessage; }

      /**
        * Retrieves the use security policy flag
        */
      public boolean getUsePolicy() { return mbUsePolicy; }

}