/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.proxies;

import eu.gemss.components.transport.servicedescription.ServiceDescription;
import eu.gemss.components.transport.payload.Payload;
import eu.gemss.GridException;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Map;

/**
 * An interface for a utility to invoke remote web services.
 */
public interface WebServiceInvoker {

	public final static String mstaticStatusValueNotStarted = "WSInvocation-NotStarted";
      public final static String mstaticStatusValueStarted = "WSInvocation-Started";
      public final static String mstaticStatusValueFinished = "WSInvocation-Finished";
      public final static String mstaticStatusValueFailed = "WSInvocation-Failed";

	/**
	 * Invoke a service, returning a proxy handle to the invocation. A return of null indicates a failure.
	 * This method will support payloads up to a few KByte using the SOAP invokeService methods provided
	 * by the transport component.
	 * @param serviceDescription description of the web service we want to invoke
	 * @param payload payload containing the operation and arguments for this invocation
	 * @param strID caller supplied ID so that web service invocations can be identified later if serialized
	 * then de-serialized. The handles are dynamic and will change for each serialized web service proxy object,
	 * so the supplied ID is the only persistent identifier for a servive invocation call.
	 * @return handle to the thread dealing with this invocation, or null if failed to initialize
	 */
	public String invokeService( ServiceDescription serviceDescription, Payload payload, String strID );

	/**
	 * Invoke a service, returning a proxy handle to the invocation. A return of null indicates a failure.
	 * This method will support payloads up to a few KByte AND up to 2GByte files using the SOAP attachment
	 * invokeService methods provided by the transport component.
	 * @param serviceDescription description of the web service we want to invoke
	 * @param payload payload containing the operation and arguments for this invocation
	 * @param strID caller supplied ID so that web service invocations can be identified later if serialized
	 * then de-serialized. The handles are dynamic and will change for each serialized web service proxy object,
	 * so the supplied ID is the only persistent identifier for a servive invocation call.
	 * @param mapFilenames Map of the filenames required by this operation invocation. This map will hold a number of
	 * <tag> <filename> entries with the appropriate operation's parameter tag's all filled out. If these are wrong then
	 * the invocation will throw an exeception. Note: the map instance MUST be seializable like the HashMap.
	 * @return handle to the thread dealing with this invocation, or null if failed to initialize
	 */
	public String invokeService( ServiceDescription serviceDescription, Payload payload, String strID, Map mapFilenames );

	/**
	 * Get the current status of an invocation. A null return indicates an invalid handle.
	 * @param strProxyHandle Handle identifying a particular invocation
	 * @return vector of flag strings describing the current status of the invocation
	 */
	public Vector getInvocationFlags( String strProxyHandle );

	/**
	 * Return the payload, or null if the invocation is still running. If the invocation failed then
	 * this method will throw the GridException that resulted in the invocation's failure. This method
	 * must be called since it removes all trace of the invocation, including its handle. If it is not called
	 * the payload and thread will remain in memory until shutdown. The result objects must
	 * thus be kept and used by the caller or lost forever. The payload can be of zero length
	 * depending on the service return value.
	 * @param strProxyHandle Handle identifying a particular invocation
	 * @return Payload object containing the result of the invocation
	 */
	public Payload getInvocationResult( String strProxyHandle ) throws GridException;

	/**
	 * Returns a hash table active proxy handles and states. Each object in the hash table is a
	 * currently active handle to a web service invocation. The key associated with the
	 * object is ID string (provided as a parameter to a invokeService call)
	 * @return Hash table where each key is an ID string and each object is an active invocation handle
	 */
	public Hashtable getActiveHandles();
}
