/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/08/13 10:55:29 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////


package eu.gemss.components.proxies.qos; 


public interface QoSProxy { 

    public void init(String wsdlEndpoint);
    
    /**
     * 	Returns an offer from the specified service(wsdlEndpoint) based on the 
     *  given <CODE>Request Descriptor</CODE> and 
     *  <CODE>QoS Descriptor</CODE> in form on a new
     *  <CODE>QoS Descriptor</CODE>
     * 
     *  @return {@link String} 
     */ 
    public String requestQoSDescriptor(String qoSDescriptor, String requestDescriptor); 
    
    /**
     * 	Returns a confirmed <CODE>QoS Descriptor</CODE> from the specified 
     *  service(wsdlEndpoint) based by confirming an offer received by the  
     *  <CODE>requestQoSDescriptor</CODE> method
     * 
     *  @return {@link String} 
     */ 
    public String confirmQoSDescriptor(String qoSDescriptor);
    
    /**
     * 	Optional cancellation of the given <CODE>QoS Descriptor</CODE> 
     *  on the given service 
     */
    public void cancelQoSDescriptor(String qoSDescriptor);
}
